#property  copyright ""
#property  link      ""

#property  indicator_separate_window
#property  indicator_buffers 2
#property  indicator_color1  Lime
#property  indicator_color2  Red
 
extern int period=10;

double         ExtBuffer0[];
double         ExtBuffer1[];
double         ExtBuffer2[];
double         Value[];


int init()
{
   IndicatorBuffers(4);
   SetIndexBuffer(0,ExtBuffer1);
   SetIndexBuffer(1,ExtBuffer2);
   SetIndexBuffer(2,ExtBuffer0);
   SetIndexBuffer(3,Value);

   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexStyle(1,DRAW_HISTOGRAM);

   IndicatorShortName("Fisher''s transform");
   IndicatorDigits(Digits+1);
   return(0);
}


int start()
{
   int   limit;
   int   counted_bars=IndicatorCounted();

   if(counted_bars>0) counted_bars--;
           limit=Bars-counted_bars;

   for(int i=limit; i>=0; i--)
   {  
      double MaxH  = High[iHighest(NULL,0,MODE_HIGH,period,i)];
      double MinL  = Low [iLowest( NULL,0,MODE_LOW, period,i)];
      double price = (High[i]+Low[i])/2;
      if (MaxH!=MinL)
            Value[i] = 0.33*2*((price-MinL)/(MaxH-MinL)-0.5) + 0.67*Value[i+1];
      else  Value[i] = 0.00;
            Value[i] = MathMin(MathMax(Value[i],-0.999),0.999); 
            ExtBuffer0[i]=0.5*MathLog((1+Value[i])/(1-Value[i]))+0.5*ExtBuffer0[i+1];

      // 
      //
      //
      //
      //
      
      if(ExtBuffer0[i]<ExtBuffer0[i+1])
      {
         ExtBuffer2[i]=ExtBuffer0[i];
         ExtBuffer1[i]=0.0;
      }
      else
      {
         ExtBuffer1[i]=ExtBuffer0[i];
         ExtBuffer2[i]=0.0;
      }
   }
   return(0);
}